<?php
/**
 * ManageWhatsAppApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Utils;
use GuzzleHttp\RequestOptions;
use Infobip\ApiException;
use Infobip\Configuration;
use Infobip\HeaderSelector;
use Infobip\ObjectSerializer;

/**
 * ManageWhatsAppApi Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */
class ManageWhatsAppApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
    * @param ClientInterface $client
    * @param Configuration   $config
    * @param HeaderSelector  $selector
    */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createWhatsAppTemplate
     *
     * Create WhatsApp Template
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppTemplatePublicApiRequest $whatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppTemplateApiResponse|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function createWhatsAppTemplate($sender, $whatsAppTemplatePublicApiRequest)
    {
        list($response) = $this->createWhatsAppTemplateWithHttpInfo($sender, $whatsAppTemplatePublicApiRequest);
        return $response;
    }

    /**
     * Operation createWhatsAppTemplateWithHttpInfo
     *
     * Create WhatsApp Template
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppTemplatePublicApiRequest $whatsAppTemplatePublicApiRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppTemplateApiResponse|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWhatsAppTemplateWithHttpInfo($sender, $whatsAppTemplatePublicApiRequest)
    {
        $request = $this->createWhatsAppTemplateRequest($sender, $whatsAppTemplatePublicApiRequest);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->createWhatsAppTemplateResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->createWhatsAppTemplateApiException($e);
        }
    }

    /**
     * Operation createWhatsAppTemplateAsync
     *
     * Create WhatsApp Template
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppTemplatePublicApiRequest $whatsAppTemplatePublicApiRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWhatsAppTemplateAsync($sender, $whatsAppTemplatePublicApiRequest)
    {
        return $this->createWhatsAppTemplateAsyncWithHttpInfo($sender, $whatsAppTemplatePublicApiRequest)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWhatsAppTemplateAsyncWithHttpInfo
     *
     * Create WhatsApp Template
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppTemplatePublicApiRequest $whatsAppTemplatePublicApiRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWhatsAppTemplateAsyncWithHttpInfo($sender, $whatsAppTemplatePublicApiRequest)
    {
        $request = $this->createWhatsAppTemplateRequest($sender, $whatsAppTemplatePublicApiRequest);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->createWhatsAppTemplateResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->createWhatsAppTemplateApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'createWhatsAppTemplate'
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppTemplatePublicApiRequest $whatsAppTemplatePublicApiRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createWhatsAppTemplateRequest($sender, $whatsAppTemplatePublicApiRequest)
    {
        // verify the required parameter 'sender' is set
        if ($sender === null || (is_array($sender) && count($sender) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sender when calling createWhatsAppTemplate'
            );
        }
        // verify the required parameter 'whatsAppTemplatePublicApiRequest' is set
        if ($whatsAppTemplatePublicApiRequest === null || (is_array($whatsAppTemplatePublicApiRequest) && count($whatsAppTemplatePublicApiRequest) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppTemplatePublicApiRequest when calling createWhatsAppTemplate'
            );
        }

        $resourcePath = '/whatsapp/1/senders/{sender}/templates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';



        // path params
        if ($sender !== null) {
            $resourcePath = str_replace(
                '{' . 'sender' . '}',
                ObjectSerializer::toPathValue($sender),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppTemplatePublicApiRequest)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppTemplatePublicApiRequest));
            } else {
                $httpBody = $whatsAppTemplatePublicApiRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'createWhatsAppTemplate'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppTemplateApiResponse|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function createWhatsAppTemplateResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 201) {
            $type = '\Infobip\Model\WhatsAppTemplateApiResponse';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'createWhatsAppTemplate'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function createWhatsAppTemplateApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 403) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation deleteWhatsAppMedia
     *
     * Delete media
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppUrlDeletionRequest $whatsAppUrlDeletionRequest whatsAppUrlDeletionRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|string
     */
    public function deleteWhatsAppMedia($sender, $whatsAppUrlDeletionRequest)
    {
        list($response) = $this->deleteWhatsAppMediaWithHttpInfo($sender, $whatsAppUrlDeletionRequest);
        return $response;
    }

    /**
     * Operation deleteWhatsAppMediaWithHttpInfo
     *
     * Delete media
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppUrlDeletionRequest $whatsAppUrlDeletionRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWhatsAppMediaWithHttpInfo($sender, $whatsAppUrlDeletionRequest)
    {
        $request = $this->deleteWhatsAppMediaRequest($sender, $whatsAppUrlDeletionRequest);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->deleteWhatsAppMediaResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->deleteWhatsAppMediaApiException($e);
        }
    }

    /**
     * Operation deleteWhatsAppMediaAsync
     *
     * Delete media
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppUrlDeletionRequest $whatsAppUrlDeletionRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWhatsAppMediaAsync($sender, $whatsAppUrlDeletionRequest)
    {
        return $this->deleteWhatsAppMediaAsyncWithHttpInfo($sender, $whatsAppUrlDeletionRequest)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWhatsAppMediaAsyncWithHttpInfo
     *
     * Delete media
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppUrlDeletionRequest $whatsAppUrlDeletionRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWhatsAppMediaAsyncWithHttpInfo($sender, $whatsAppUrlDeletionRequest)
    {
        $request = $this->deleteWhatsAppMediaRequest($sender, $whatsAppUrlDeletionRequest);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->deleteWhatsAppMediaResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->deleteWhatsAppMediaApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'deleteWhatsAppMedia'
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     * @param  \Infobip\Model\WhatsAppUrlDeletionRequest $whatsAppUrlDeletionRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteWhatsAppMediaRequest($sender, $whatsAppUrlDeletionRequest)
    {
        // verify the required parameter 'sender' is set
        if ($sender === null || (is_array($sender) && count($sender) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sender when calling deleteWhatsAppMedia'
            );
        }
        // verify the required parameter 'whatsAppUrlDeletionRequest' is set
        if ($whatsAppUrlDeletionRequest === null || (is_array($whatsAppUrlDeletionRequest) && count($whatsAppUrlDeletionRequest) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $whatsAppUrlDeletionRequest when calling deleteWhatsAppMedia'
            );
        }

        $resourcePath = '/whatsapp/1/senders/{sender}/media';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';



        // path params
        if ($sender !== null) {
            $resourcePath = str_replace(
                '{' . 'sender' . '}',
                ObjectSerializer::toPathValue($sender),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*'],
            ['application/json']
        );

        // for model (json/xml)
        if (isset($whatsAppUrlDeletionRequest)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($whatsAppUrlDeletionRequest));
            } else {
                $httpBody = $whatsAppUrlDeletionRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'deleteWhatsAppMedia'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of string|string|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function deleteWhatsAppMediaResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 204) {
            $type = 'string';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'deleteWhatsAppMedia'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function deleteWhatsAppMediaApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 404) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                'string',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation getWhatsAppTemplates
     *
     * Get WhatsApp Templates
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\WhatsAppTemplatesApiResponse|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException
     */
    public function getWhatsAppTemplates($sender)
    {
        list($response) = $this->getWhatsAppTemplatesWithHttpInfo($sender);
        return $response;
    }

    /**
     * Operation getWhatsAppTemplatesWithHttpInfo
     *
     * Get WhatsApp Templates
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\WhatsAppTemplatesApiResponse|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWhatsAppTemplatesWithHttpInfo($sender)
    {
        $request = $this->getWhatsAppTemplatesRequest($sender);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->getWhatsAppTemplatesResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->getWhatsAppTemplatesApiException($e);
        }
    }

    /**
     * Operation getWhatsAppTemplatesAsync
     *
     * Get WhatsApp Templates
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWhatsAppTemplatesAsync($sender)
    {
        return $this->getWhatsAppTemplatesAsyncWithHttpInfo($sender)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWhatsAppTemplatesAsyncWithHttpInfo
     *
     * Get WhatsApp Templates
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWhatsAppTemplatesAsyncWithHttpInfo($sender)
    {
        $request = $this->getWhatsAppTemplatesRequest($sender);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->getWhatsAppTemplatesResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->getWhatsAppTemplatesApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'getWhatsAppTemplates'
     *
     * @param  string $sender Registered WhatsApp sender number. Must be in international format. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getWhatsAppTemplatesRequest($sender)
    {
        // verify the required parameter 'sender' is set
        if ($sender === null || (is_array($sender) && count($sender) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sender when calling getWhatsAppTemplates'
            );
        }

        $resourcePath = '/whatsapp/1/senders/{sender}/templates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';



        // path params
        if ($sender !== null) {
            $resourcePath = str_replace(
                '{' . 'sender' . '}',
                ObjectSerializer::toPathValue($sender),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'getWhatsAppTemplates'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\WhatsAppTemplatesApiResponse|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|\Infobip\Model\WhatsAppApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function getWhatsAppTemplatesResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\WhatsAppTemplatesApiResponse';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'getWhatsAppTemplates'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function getWhatsAppTemplatesApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 401) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 403) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 429) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\WhatsAppApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
